/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
*********************************************
* FILE NAME: iir32.h
*
* PURPOSE: IIR32 module header file, containing general definitions and 
*	       function prototypes for allocating/deallocating data structures
*	       for filter and computing an Infinite Impulse Responce filter.
*
* AUTHOR:  Andrey Butok
*********************************************/
#ifndef _IIR32_H_
#define _IIR32_H_

#include "iir.h"

/******************************************
*16-bit Fractional IIR Filter
******************************************/
 typedef struct tIir32Struct
	{
	Frac32* pIirCoef;                    //Coefficients for IIR-> {a0,a1,b1,a2,b2...}
	unsigned int    iIirCoefCount;	 //Number of Coefficients=2n+1 (n=1,2,3...)
	Frac32* pIirHistory;                 // Buffer for Save hisory between function calls -> {X1,Y1,X2,Y2,X3...}
	unsigned int    iIirHistoryCount;    // Number of values in History Buffer
	};

 // Computes a Infinite Impulse Response (IIR) filter for a array of 32-bit fractional data values.
 void IIR32_EMAC( struct tIir32Struct *pIIR, Frac32* pX, Frac32* pY, unsigned int n);
 void IIR32_MAC( struct tIir32Struct *pIIR, Frac32* pX, Frac32* pY, unsigned int n);

 //Performs the initialization for IIR32 function
 struct tIir32Struct* IIR32Create( Frac32* pCoef, uint16 u16Num);
  
 //Deallocates the data structure initially allocated by IIR32Create
 void IIR32Destroy( struct tIir32Struct* pIIR);

#ifdef __EMAC
	#define IIR32(w,x,y,z)	IIR32_EMAC(w,x,y,z)
#else
	#define IIR32(w,x,y,z)	IIR32_MAC(w,x,y,z)
#endif

#endif //_IIR32_H_

